<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Slip Gaji</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .box {
            border: 1px solid #000;
            padding: 15px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        td {
            padding: 6px;
        }
        .total {
            font-weight: bold;
            font-size: 14px;
        }
        .right {
            text-align: right;
        }
    </style>
</head>
<body>

<div class="header">
    <h2>SLIP GAJI KARYAWAN</h2>
    <p>{{ now()->translatedFormat('F Y') }}</p>
</div>

<div class="box">
    <table>
        <tr>
            <td>Nama</td>
            <td>: {{ $gaji->karyawan->user->nama }}</td>
        </tr>
        <tr>
            <td>Jabatan</td>
            <td>: {{ $gaji->karyawan->jabatan->nama_jabatan }}</td>
        </tr>
        <tr>
            <td>Bulan</td>
            <td>: {{ \Carbon\Carbon::create()->month($gaji->bulan)->locale('id')->monthName }}</td>
        </tr>
        <tr>
            <td>Tahun</td>
            <td>: {{ $gaji->tahun }}</td>
        </tr>
    </table>

    <hr>

    <table>
        <tr>
            <td>Jumlah Hadir</td>
            <td class="right">{{ $gaji->total_hadir }} Hari</td>
        </tr>
        <tr>
            <td>Gaji Harian</td>
            <td class="right">
                Rp {{ number_format($gaji->gaji_harian,0,',','.') }}
            </td>
        </tr>
        <tr class="total">
            <td>Total Gaji</td>
            <td class="right">
                Rp {{ number_format($gaji->total_gaji,0,',','.') }}
            </td>
        </tr>
    </table>
</div>

<br><br>

<table width="100%">
    <tr>
        <td></td>
        <td class="right">
            {{ now()->translatedFormat('d F Y') }}<br>
            Admin
            <br><br><br>
            (__________________)
        </td>
    </tr>
</table>

</body>
</html>
